import 'jasmine';
export class jasmineSpecHelper {
	
	constructor(private logger = null) {}

	suite(title, test) {          // override the original it by a wrapper
		//do some logging...
		this.getLoggerInstance().log('info', title, 'describe');
		//Then do the original implementation
    	describe(title, function() {
    		test();
    	});
	}

	spec(title, test) {          // override the original it by a wrapper
		//do some logging...
		this.getLoggerInstance().log('info', title, 'it');
		//Then do the original implementation
    	it(title, function() {
    		test();
    	});
	}

	expect(actual) {
		expect(actual);
	}

	setLoggerInstance(logger) {
		this.logger = logger;
	}

	getLoggerInstance() {
		return this.logger;
	}
}